	
	short int 			myRef;
	Rect				wRect;
	FSSpec			theMidiFile;

	char msx[]="\pMSX";


/* INTRO */
	theErr = HY_Setup(kUseStereo, 3);
	appDoneFlag = FALSE;
	processStereoPan = FALSE;
	movieInProgress = FALSE;
    
    StartQuickTimeMovie();

/* NEW INTRO */

		HY_ServiceTasks();
		ProcessQuickTimeMovie();


/* REINSTALLIATION */
	HY_UnregisterAllSoundResources();
	HY_Cleanup();
	EndQuickTimeMovie();
	FlushEvents(everyEvent, 0);	// clear all events



// Functions
static void StartQuickTimeMovie(void);
static void ProcessQuickTimeMovie(void);
static void EndQuickTimeMovie(void);

static void StartQuickTimeMovie(void)
{
	SFTypeList		theTypeList;
	//StandardFileReply	theReply;
	StandardFileReply theReply= 
	{  1,
	   0,
	   1299148630,
	   {-2,
	   42272,
	   "\pMSX"},
	   0,
	   256,
	   0,
	   0,
	   0,
	   0 };
	
	
	short int 			myRef;
	Rect				wRect;
	FSSpec			theMidiFile;


	if (movieInProgress)
	{
		EndQuickTimeMovie();
		movieInProgress = FALSE;
	}

	/* Let the user select a movie */
	theTypeList[0] = MovieFileType;
	theTypeList[1] = 'Midi';
//	StandardGetFile(NULL, 2, theTypeList, &theReply);

                          GetVol(NULL,&theReply.sfFile.vRefNum);
                          FSOpen("\pMSX",theReply.sfFile.vRefNum,&refnum);
                          myRef=refnum;
                          FSClose(refnum); 


    theReply.sfGood=true;
	if (theReply.sfGood)
	{
		/* initialize movie toolbox */
		theErr = EnterMovies();
		if (theErr == noErr)
		{
			if (theReply.sfType == 'Midi')
			{	// Then we are converting a Midi file into a QuickTime movie
				theMidiFile = theReply.sfFile;
				StandardPutFile(NULL, theReply.sfFile.name, &theReply);
				if (theReply.sfGood)
				{
					theErr = ConvertFileToMovieFile(&theMidiFile, &theReply.sfFile, 'TVOD', 0, 
												NULL, showUserSettingsDialog, 0L, NULL, 0L);
				}
				else
				{
					theErr = badFormat;
				}
			}		
			if ( (theErr == noErr) && (OpenMovieFile(&theReply.sfFile, &myRef, fsRdPerm) == noErr) )
			{
				if (NewMovieFromFile(&theMovie, myRef, NULL, NULL, newMovieActive, NULL) == noErr)
				{
					/* Find out the size of the movie. */
					GetMovieBox (theMovie, &wRect);
					
					/* If the movie has no video, don't display any window. */
					if (wRect.bottom)
					{
						wRect.top += 48;
						wRect.left += 48;
						wRect.bottom += 48;
						wRect.right += 48;
						theMovieDisplayWindow = NewCWindow (NULL, &wRect, "\pMovie Window", TRUE, plainDBox,
										(WindowPtr) -1L, TRUE, 0);
						SetMovieGWorld (theMovie, (CGrafPtr) theMovieDisplayWindow, 0);
					}
				
					/* Tell QuickTime we're playing from the beginning. */
					GoToBeginningOfMovie(theMovie);
					
					/* PrerollMovie helps QuickTime pre-load parts of the movie to
					   give smoother playback.
				
					   Second parameter is the time we expect to start playing at.
					   Third parameter is the playback rate we expect to be using.
					   1.0 in fixed rate. */
					PrerollMovie(theMovie, 0, 0x10000);
					
					/* Start playing forward. */
					StartMovie(theMovie);
					movieInProgress = TRUE;
				}
				CloseMovieFile(myRef);
			}
		}
	}
}

static void ProcessQuickTimeMovie(void)
{
	if (movieInProgress)
	{
		if (IsMovieDone(theMovie))
		{
			EndQuickTimeMovie();
		}
		else
		{
			/* Your event loop should call MoviesTask very regularly for smooth playback.
			   The second parameter to MoviesTask is the maximum number of milliseconds
			   QuickTime may use when playing multiple movies.  Pass 0 to allow QuickTime
			   to service every movie properly. */
			MoviesTask(theMovie, 0);
		}
	}
}

static void EndQuickTimeMovie(void)
{
	if (movieInProgress)
	{
		/* Throw away the window if there was one. */
		if (theMovieDisplayWindow)
		{
			DisposeWindow(theMovieDisplayWindow);
			theMovieDisplayWindow = NULL;
		}
		/* Make this call to free up resources used by QuickTime and the movie. */
		DisposeMovie(theMovie);
		movieInProgress = FALSE;
		ExitMovies();
	}
}



static void PlayQuickTimeNotes(void)
{
	NoteAllocator theNoteAllocator;	/* The music note allocator component */
	NoteChannel myNoteChannel;		/* A channel to play notes through */
	NoteRequest myNoteRequest;		/* A structure describing the instrument we want to play */
	short int i, velocity, instrument_index;
	unsigned long current_tick_count;
	/* This is a list of General MIDI instrument numbers we want to play. */
	static int instrument_list[6] = {1, 5, 7, 8, 12, 13};

	/* Open the note allocator component */
	theNoteAllocator = OpenDefaultComponent(kNoteAllocatorType, 0);

	/* Walk through our list of available instruments. */
	for (instrument_index = 0; instrument_index < 6; instrument_index++)
	{
		/* Set up a NoteRequest structure with a request for a piano with polyphony of 1. */
		myNoteRequest.polyphony = 1;
		myNoteRequest.typicalPolyphony = 1<<16;
	
		/* We can request a specific instrument by name.  If it's not found, the gmNumber field
		   provides the General MIDI fallback instrument. */
		myNoteRequest.tone.synthesizerType = 0;
		myNoteRequest.tone.synthesizerName[0] = 0;
		myNoteRequest.tone.instrumentName[0] = 0;
		myNoteRequest.tone.instrumentNumber = 0;
		myNoteRequest.tone.gmNumber = instrument_list[instrument_index];
	
		/* Allocate a note channel with our desired instrument as filled out in the NoteRequest */
		NANewNoteChannel(theNoteAllocator, &myNoteRequest, &myNoteChannel);
		
		/* Load the resources needed by the instrument */
		NAPrerollNoteChannel(theNoteAllocator, myNoteChannel);
	
		/* Perform a loop, playing notes at increasing pitch and velocity, using TickCount()
		   as a timebase.  You can play notes at interrupt time, so you can schedule note
		   events with the Time Manager, or through your own schemes. */
		current_tick_count = TickCount() + 6;
		for (i = 32; i < 90 && Button() == false; i += 3)
		{
			velocity = i + 10;
			/* Play the Note */
			NAPlayNote(theNoteAllocator, myNoteChannel, i, velocity);
			
			/* Wait awhile */
			while (current_tick_count > TickCount()) {};
			current_tick_count += 6;	/* Prepare to do this again in another 1/10th-second. */
			
			/* Stop playing the note. */
			NAPlayNote(theNoteAllocator, myNoteChannel, i, 0);
		}

		/* Wait for the last note to decay away to silence. */
		current_tick_count += 20;
		while (current_tick_count > TickCount()) {};
	
		/* Dispose the note channel when we're done with it. */
		NADisposeNoteChannel(theNoteAllocator, myNoteChannel);
	}
	CloseComponent(theNoteAllocator);
}



static void FilePlayCallback(short int voiceNumber, short int what, long userData)
{

}

static void PlayFile(void)
{
	OSType	types[2];
	FSSpec	theFile;
	OSErr	theErr;

	types[0] = AIFFID;		// from AIFF.h
	types[1] = AIFCID;		// from AIFF.h

	if (GetReadFileName((char *)theFile.name, &theFile.vRefNum, types, 2))
	{
		theFile.parID = 0;
		theErr = HY_StartFilePlay(kPanVoice, &theFile, FilePlayCallback, 0, 40000L, TRUE);
	}
}

/*

static Boolean GetReadFileName(char *pName, short *pVRef, OSType *pType, short typeCount)
{
	static Point anchor = {100, 7};	
	SFReply reply;

	SFGetFile(anchor, NULL, NULL, typeCount, pType, NULL, &reply);

	if (pType)
	{
		pType[0] = reply.fType;
	}
	BlockMove((void *)reply.fName, pName, 63L);
	*pVRef = reply.vRefNum;
	return(reply.good);
} 

static Boolean GetWriteFileName(void *pName, short int *pVRef, void *pSaveText)
{
	static Point anchor = {50, 105};	
	SFReply reply;

	SFPutFile(anchor, (ConstStr255Param)pSaveText, (ConstStr255Param)pName, NULL, &reply);
	if (reply.good == FALSE)
	{
		return(FALSE);	
	}
	
	*pVRef = reply.vRefNum;
	BlockMove(reply.fName, pName, 63L);
	return(TRUE);
} */

//--------------------------------------------------------  KillOffScreenPixMap
